@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="cmn-section">
        <div class="container">
            <div class="row cmn-text">
                <div class="col-md-12 mb-4">
                    <div class="notice"></div>
                    @php
                        $kyc = getContent('kyc.content', true);
                    @endphp
                    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
                        <div class="alert alert-danger" role="alert">
                            <div class="d-flex justify-content-between">
                                <h4 class="alert-heading">@lang('KYC Documents Rejected')</h4>
                                <button class="btn btn--base" data-bs-toggle="modal" data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                            </div>
                            <hr>
                            <p class="mb-0 text--dark">
                                {{ __(@$kyc->data_values->reject) }} <a href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>,
                                <a href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                            </p>
                        </div>
                    @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED)
                        <div class="alert alert-info" role="alert">
                            <h4 class="alert-heading">@lang('KYC Verification required')</h4>
                            <hr>
                            <p class="mb-0">{{ __(@$kyc->data_values->required) }} <a href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                        </div>
                    @elseif(auth()->user()->kv == Status::KYC_PENDING)
                        <div class="alert alert-warning" role="alert">
                            <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
                            <hr>
                            <p class="mb-0">{{ __(@$kyc->data_values->pending) }} <a href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                        </div>
                    @endif
                </div>
                <div class="col-md-6 mb-30">
                    <div class="widget-two h-100 border--widget b-radius--8 bg--white">
                        <div class="widget-two__icon b-radius--8 w-bg--success">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="M341.954 328.358c-12.131 0-22-8.542-22-19.041 0-10.5 9.869-19.042 22-19.042s22 8.542 22 19.042c0 5.522 4.478 10 10 10s10-4.478 10-10c0-18.325-13.654-33.733-32-37.915v-5.201c0-5.522-4.478-10-10-10s-10 4.478-10 10v5.201c-18.346 4.182-32 19.59-32 37.915 0 21.527 18.841 39.041 42 39.041 12.131 0 22 8.542 22 19.042s-9.869 19.042-22 19.042-22-8.542-22-19.042c0-5.522-4.478-10-10-10s-10 4.478-10 10c0 18.325 13.654 33.733 32 37.915v4.32c0 5.522 4.478 10 10 10s10-4.478 10-10v-4.32c18.346-4.182 32-19.59 32-37.915 0-21.528-18.841-39.042-42-39.042zM451.482 268.876a130.294 130.294 0 0 0-53.222-47.101c-4.979-2.394-10.954-.298-13.346 4.68-2.393 4.978-.298 10.952 4.68 13.345C427.505 258.024 452 296.963 452 339.001c0 17.988-4.434 35.827-12.821 51.591-2.594 4.875-.745 10.931 4.131 13.525a10 10 0 0 0 13.525-4.131C466.756 381.342 472 360.253 472 339.001c0-24.96-7.095-49.209-20.518-70.125zM357.673 209.002l-.673-.001c-5.522 0-10 4.477-10 10s4.478 10 10 10l.579.001h.048c5.501 0 9.973-4.446 9.999-9.953.025-5.523-4.431-10.021-9.953-10.047zM294.407 438.202c-37.91-18.225-62.405-57.164-62.405-99.201 0-17.988 4.434-35.827 12.821-51.591 2.594-4.875.745-10.931-4.131-13.525-4.874-2.594-10.932-.745-13.525 4.131-9.921 18.645-15.165 39.733-15.165 60.985 0 24.96 7.095 49.208 20.518 70.125a130.304 130.304 0 0 0 53.222 47.102 10.002 10.002 0 0 0 8.665-18.026zM327.002 449.001l-.579-.002c-5.548-.01-10.02 4.429-10.045 9.953-.026 5.523 4.432 10.021 9.954 10.047l.67.002c5.522 0 10-4.478 10-10s-4.478-10-10-10z"
                                        opacity="1" data-original="#000000" class=""></path>
                                    <path
                                        d="M387.409 175.168a45.9 45.9 0 0 0-4.443-8.168H409c25.364 0 46-20.636 46-46s-20.636-46-46-46h-80.08A45.733 45.733 0 0 0 337 49c0-25.364-20.636-46-46-46H46C20.636 3 0 23.636 0 49s20.636 46 46 46h80.08c-5.091 7.402-8.08 16.357-8.08 26s2.988 18.598 8.08 26H100c-25.364 0-46 20.636-46 46 0 14.567 6.814 27.566 17.415 36C60.814 237.434 54 250.433 54 265s6.814 27.566 17.415 36C60.814 309.434 54 322.433 54 337s6.814 27.566 17.415 36C60.814 381.434 54 394.433 54 409c0 25.364 20.636 46 46 46h117.85c31.046 33.207 75.212 54.001 124.151 54.001 93.738 0 170-76.262 170-170 0-78.017-52.83-143.918-124.592-163.833zM409 95c14.337 0 26 11.664 26 26s-11.663 26-26 26H164c-14.337 0-26-11.664-26-26s11.663-26 26-26h245zM46 75c-14.337 0-26-11.664-26-26s11.663-26 26-26h245c14.337 0 26 11.664 26 26s-11.663 26-26 26H46zm54 92h245c4.028 0 7.885.936 11.345 2.612-4.73-.397-9.512-.611-14.344-.611-46.945 0-89.505 19.129-120.299 49.999H100c-14.336 0-26-11.664-26-26s11.664-26 26-26zm0 72h104.615c-11.352 15.553-20.129 33.095-25.703 52H100c-14.337 0-26-11.663-26-26 0-14.336 11.663-26 26-26zm0 72h74.32a170.4 170.4 0 0 0-2.319 28.001c0 8.146.589 16.156 1.702 23.999H100c-14.337 0-26-11.663-26-26s11.663-26 26-26zm0 124c-14.337 0-26-11.663-26-26s11.663-26 26-26h77.786a169.33 169.33 0 0 0 23.993 52H100zm242.001 54.001c-82.71 0-150-67.29-150-150s67.29-150 150-150 150 67.29 150 150-67.29 150-150 150z"
                                        opacity="1" data-original="#000000" class=""></path>
                                </g>
                            </svg>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="balance">{{ showAmount($user->balance) }} </h3>
                            <div class="d-flex flex-wrap justify-content-between position-relative">
                                <p>@lang('My Balance')</p>
                                <a href="{{ route('user.withdraw') }}" class="btn cmn-btn">@lang('Withdraw Now') <i
                                        class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>
                    </div><!-- widget-two end -->
                </div>
                <div class="col-md-6 mb-30">
                    <div class="widget-two h-100 border--widget b-radius--8 bg--white">
                        <div class="widget-two__icon b-radius--8 w-bg--primary">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="512"
                                height="512" x="0" y="0" viewBox="0 0 46.91 48" style="enable-background:new 0 0 512 512" xml:space="preserve"
                                class="">
                                <g>
                                    <g data-name="Layer 2">
                                        <g data-name="Layer 1">
                                            <path
                                                d="M8.75 15.82a.73.73 0 0 1 1.13-.92l.56.69 1.37-2.11a.73.73 0 1 1 1.22.79l-1.91 2.94a.7.7 0 0 1-.57.33.71.71 0 0 1-.56-.26zm1.2 7a.72.72 0 0 0 .56.27.75.75 0 0 0 .57-.33L13 19.8a.73.73 0 0 0-1.19-.8l-1.37 2.11-.56-.69a.73.73 0 1 0-1.13.93zm0 5.66a.72.72 0 0 0 .56.27.73.73 0 0 0 .57-.33L13 25.47a.73.73 0 0 0-.22-1 .72.72 0 0 0-1 .22l-1.37 2.1-.56-.68a.73.73 0 0 0-1.1.89zm5.87-12.4h9.58a.73.73 0 1 0 0-1.45h-9.58a.73.73 0 0 0 0 1.45zm0 5.54h5.94a.73.73 0 1 0 0-1.46h-5.94a.73.73 0 0 0 0 1.46zm0 5.66h8.12a.73.73 0 0 0 .73-.73.72.72 0 0 0-.73-.72h-8.12a.72.72 0 0 0-.72.72.73.73 0 0 0 .72.72zm31.09 7a10.56 10.56 0 0 1-10.55 10.48h-.72v.46A2.82 2.82 0 0 1 32.82 48h-30A2.81 2.81 0 0 1 0 45.19V7.78A2.81 2.81 0 0 1 2.81 5h5.7a2.29 2.29 0 0 1 2.12-1.42h3a4.28 4.28 0 0 1 8.43 0h3A2.3 2.3 0 0 1 27.13 5h5.69a2.82 2.82 0 0 1 2.82 2.81v15.9h.72a10.56 10.56 0 0 1 10.55 10.51zM32.82 6.42h-5.51v2.33h2.87a.73.73 0 0 1 .73.73v15.73a10.63 10.63 0 0 1 3.27-1.31V7.78a1.36 1.36 0 0 0-1.36-1.36zM6.18 10.2v30.55H28.1a10.51 10.51 0 0 1 1.35-14.48V10.2H27a2.3 2.3 0 0 1-2 1.21H10.63a2.28 2.28 0 0 1-2-1.21zm3.6-1.09a.85.85 0 0 0 .85.85H25a.85.85 0 0 0 .85-.85V5.85A.85.85 0 0 0 25 5h-3.63a.72.72 0 0 1-.73-.72 2.82 2.82 0 1 0-5.64 0 .73.73 0 0 1-.73.72h-3.64a.85.85 0 0 0-.85.85zm24.4 35.43a10.56 10.56 0 0 1-4.69-2.34h-24a.72.72 0 0 1-.72-.72v-32a.72.72 0 0 1 .72-.73h2.84V6.42H2.81a1.35 1.35 0 0 0-1.35 1.36v37.41a1.34 1.34 0 0 0 1.35 1.35h30a1.35 1.35 0 0 0 1.36-1.35zm11.27-10.32a9.09 9.09 0 1 0-9.09 9.09 9.1 9.1 0 0 0 9.09-9.09zm-9.09-3.82a1.68 1.68 0 0 1 1.78 1.6.73.73 0 0 0 1.45 0 3.06 3.06 0 0 0-2.5-3v-.61a.73.73 0 0 0-1.45 0V29a3.07 3.07 0 0 0-2.51 3 2.89 2.89 0 0 0 3.23 3c1.18 0 1.78.52 1.78 1.54a1.79 1.79 0 0 1-3.55 0 .73.73 0 0 0-1.46 0 3.07 3.07 0 0 0 2.51 2.92V40a.73.73 0 0 0 1.45 0v-.61a3.06 3.06 0 0 0 2.5-2.92 2.89 2.89 0 0 0-3.23-3c-1.17 0-1.77-.52-1.77-1.54a1.67 1.67 0 0 1 1.77-1.53zm-26.48 3a.72.72 0 0 0-.72.72v4.18a.73.73 0 1 0 1.45 0v-4.19a.72.72 0 0 0-.73-.72zm4.2 5.6a.73.73 0 0 0 .73-.73v-2.7a.73.73 0 1 0-1.46 0v2.72a.73.73 0 0 0 .73.71zm4.2-7.82a.73.73 0 0 0-.73.73v6.36a.73.73 0 1 0 1.46 0v-6.34a.73.73 0 0 0-.73-.73zm4.19-1.45a.72.72 0 0 0-.72.73v7.81a.73.73 0 1 0 1.45 0v-7.79a.72.72 0 0 0-.73-.73z"
                                                data-name="financial plan" opacity="1" data-original="#000000" class="">
                                            </path>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="balance">


                                @if ($user->plan)
                                    {{ __($user->plan->name) }} @if ($user->expire_date < now())
                                        (@lang('Expired'))
                                    @endif
                                @else
                                    @lang('No Plan')
                                @endif
                                </h2>
                                <div class="d-flex flex-wrap justify-content-between position-relative">
                                    <p>@lang('My Plan')</p>
                                    <a href="{{ route('plans') }}" class="btn cmn-btn">
                                        @if ($user->expire_date >= now())
                                            @lang('Change Plan')
                                        @else
                                            @lang('Choose Plan')
                                        @endif
                                        <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                                @if ($user->expire_date >= now())
                                    <small class="text--danger">@lang('expire in')
                                        {{ \Carbon\Carbon::parse($user->expire_date)->format('Y-m-d') }}</small>
                                @endif
                        </div>
                    </div><!-- widget-two end -->
                </div>
                <div class="col-lg-8 col-md-12 mb-30">
                    <div class="card border--widget">
                        <div class="card-body">
                            <h5 class="card-title">@lang('Click & Earn Report')</h5>
                            <div id="apex-bar-chart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12 mb-30">
                    <div class="row">
                        <div class="col-lg-12 col-md-6 mb-30">
                            <div class="widget-three border--widget b-radius--8 bg--white">
                                <div class="widget-three__icon b-radius--8 w-bg--primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                        viewBox="0 0 492.4 512.6" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                        <g>
                                            <path
                                                d="M492.4 144.9V0H255.6c-5.5 0-10.9 1.8-15.2 5.2l-.2.2-78.1 71.4c-3.4 2.8-6.1 6.3-8 10.3H70.4c-4.9 0-8.9 4-8.9 8.9v127.2L0 248.3v47.9h18.7v26.7h16.1v111.3H16.1v30.2H0v48.2h453.2v-48.2h-16.1v-30.2h-18.8V322.9h16.1v-26.7h18.8v-47.9L398.7 226v-71c5.9-2.6 11.3-6 16.2-10.1zM438.8 12h41.6v120.9h-41.6zM163.3 99.1h42.3c.1.9.3 1.8.5 2.7 1.5 7.2 5.7 13.5 11.7 17.6-14.2 4.5-25.9 16.1-32.3 31.3h-14.9v12h11.3c-.6 2.6-1 5.3-1.2 8h-25.3v12h25.3c.2 2.7.6 5.4 1.2 8h-12.3v12h15.9c8.2 19.7 25.5 33.4 45.4 33.4s37.2-13.7 45.4-33.4h20.5v-12H280c.5-2.6.9-5.3 1.2-8h33.2v-12h-33.2c-.3-2.7-.7-5.4-1.2-8h15.6v-12h-19.3c-5.6-13.4-15.4-24-27.3-29.4l52.3-11.5c7.6 4.7 15.4 8.9 23.6 12.4 11 22 33.6 35.9 58.2 35.9h3.6v36.6h-3.6c-33.6 0-61.7 25.6-64.8 59.1H139.7c-3.2-33.4-31.2-59-64.8-59.1h-1.4v-37c30.3-3.8 53.9-28.2 56.5-58.6zm67.6 30.3c21.3 0 38.5 21.2 38.5 47.3s-17.2 47.4-38.5 47.4-38.5-21.3-38.5-47.4 17.3-47.3 38.5-47.3zM386.7 146h-3.6c-15.1 0-29.5-6.4-39.6-17.7 2.4.6 4.9 1 7.4 1.2 3.9.5 7.9.7 11.9.7 8.1.1 16.1-1 23.9-3.3zM118 99.1c-2.7 23.7-20.9 42.7-44.5 46.4V99.1zM73.5 206.6h1.4c27 .1 49.6 20.3 52.7 47.1H73.5v-47zm56 89.6v26.7h16.1v111.3H86.4V322.9h16.1v-26.7zm166.5 138h-27.6V322.9H296zm-39.6-123.3h-4.1v-13h59.8v13zm0 12v111.3h-59.2V322.9h16.1v-26.7h27v26.7zm-114.9-25h59.8v13h-59.8zm16.1 25h27.6v111.3h-27.6zm-126.9-12v-13h59.8v13zm16.1 12h27.6v111.3H46.8zm394.4 177.7H12v-24.2h429.2zm-16.1-54.4v18.2h-397v-18.2zm-18.8-12h-27.6V322.9h27.6zm16.1-123.3h-59.8v-13h59.8zm-55.7 12v111.3H308V322.9h16.1v-26.7h26.5v26.7zm74.5-66.5v27.8H12v-27.8l49.5-20.3v20.6c0 4.9 4 8.9 8.9 8.9h328.3V239zm-54.5-22.3v19.5h-56.4c3.1-26.8 25.8-47.1 52.8-47.1h3.6zm25.9-101.2h-2.5l-1.8 1.7c-2.9 2.8-6.1 5.1-9.6 7v-19.5c8.8-4.5 14.9-10.2 19.6-14.5l1.5-1.3-8.1-8.9-1.5 1.4c-3.6 3.4-7.4 6.5-11.5 9.3-3.7 2.6-7.8 4.6-12 6.2-8.6 3.2-19.8 5-34.6 3.4-6.3-.8-12.4-2.4-18.3-4.8-4.9-2-9.8-4.2-14.5-6.7-5.9-3.1-10.5-5.9-12.5-7.1l-1.1-.7-2.1-1.4-9.5 2.1-57.4 12.6h-.2c-3.9 1-8 .4-11.4-1.8-3.8-2.4-6.4-6.2-7.3-10.6v-.2c-.9-4.1-.3-8.3 1.6-12 2.1-4.2 5.9-7.4 10.4-8.8l73.3-23.1 1.1-1.1c.1-.2 12.4-13 34.5-12l.6-12c-23.6-1-38.4 10.7-42.6 14.6l-70.2 22.1c-9.7 2.8-17.3 10.5-20 20.3h-37.9l1.2-1.1h.1l78-71.3c2.2-1.7 4.9-2.6 7.7-2.6h171.2v120.8z"
                                                opacity="1" data-original="#000000" class=""></path>
                                            <path d="M453.6 113.5h12v12.3h-12z" opacity="1" data-original="#000000" class=""></path>
                                        </g>
                                    </svg>
                                </div>
                                <div class="widget-three__content">
                                    <h3>{{ showAmount($user->deposits->sum('amount')) }}</h3>
                                    <p>@lang('Total Deposit')</p>
                                    <div class="div">
                                        <a href="{{ route('user.deposit.history') }}" class="btn cmn-btn mt-2">@lang('Deposit History ')<i
                                                class="fas fa-arrow-circle-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-6 mb-30">
                            <div class="widget-three border--widget b-radius--8 bg--white">
                                <div class="widget-three__icon b-radius--8 w-bg--success">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                        viewBox="0 0 66 66" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                        <g>
                                            <path
                                                d="M35.73 31.54a5.16 5.16 0 1 0 0-10.32 5.16 5.16 0 0 0 0 10.32zm0-8.31c1.74 0 3.16 1.42 3.16 3.16s-1.42 3.16-3.16 3.16-3.16-1.42-3.16-3.16 1.42-3.16 3.16-3.16z"
                                                opacity="1" data-original="#000000" class="">
                                            </path>
                                            <path
                                                d="M60.9 1.02H10.56c-1.7 0-3.08 1.38-3.08 3.08v11.21c0 1.7 1.38 3.09 3.08 3.09h10.93v11.14l-7.35 7.28a2.4 2.4 0 0 0-.47.66L8.26 48.85l-.4-.4c-.43-.43-1.01-.67-1.63-.68h-.01c-.62 0-1.19.24-1.63.67L2.7 50.33c-.9.9-.9 2.37 0 3.27l10.7 10.7c.44.44 1.02.68 1.64.68s1.2-.24 1.64-.68l1.89-1.89c.43-.43.67-1.01.67-1.63s-.24-1.2-.68-1.64l-.25-.25 6.54-6.47c.25-.25.33-.6.25-.93h21.55c1.84 0 3.33-1.5 3.33-3.33V18.4h4.11c.55 0 1-.45 1-1s-.45-1-1-1h-4.11v-3.44h2.26c.87 0 1.68-.34 2.3-.95s.95-1.43.95-2.3c0-1.79-1.46-3.25-3.25-3.25h-33c-.87 0-1.68.34-2.3.95s-.95 1.43-.95 2.3c0 1.79 1.46 3.25 3.25 3.25h2.26v3.44H10.56c-.6 0-1.08-.49-1.08-1.09V4.1c0-.6.48-1.08 1.08-1.08H60.9c.6 0 1.08.48 1.08 1.08v11.21c0 .6-.48 1.09-1.08 1.09-.55 0-1 .45-1 1s.45 1 1 1c1.7 0 3.08-1.39 3.08-3.09V4.1c0-1.69-1.38-3.08-3.08-3.08zM17.14 60.99l-1.89 1.89c-.15.15-.28.16-.44 0l-10.7-10.7a.314.314 0 0 1 0-.44L6 49.85c.06-.06.13-.08.21-.08s.16.03.22.09l10.7 10.7c.08.08.09.16.09.22.01.05-.01.14-.08.21zM49.97 8.46h2.26c.69 0 1.25.56 1.25 1.25 0 .33-.13.65-.37.88s-.55.37-.88.37h-2.26zm-26.48 0h24.47v39.69c0 .73-.6 1.33-1.33 1.33H26.04l1.14-3.41c.24-.71.65-1.37 1.18-1.9l1.01-1c.7.56 1.11 1.39 1.11 2.31 0 .55.45 1 1 1h8.48c.55 0 1-.45 1-1 0-1.65 1.34-3 3-3 .55 0 1-.45 1-1V16.27c0-.55-.45-1-1-1-1.65 0-3-1.34-3-3 0-.55-.45-1-1-1h-8.48c-.55 0-1 .45-1 1 0 1.65-1.34 3-3 3-.55 0-1 .45-1 1v20.76l-3 2.97V8.46zm7.53 28.59c-.6-.61-1.4-.94-2.26-.95h-.02c-.09 0-.17.02-.25.02V17.17a5.01 5.01 0 0 0 3.9-3.9h6.68a5.01 5.01 0 0 0 3.9 3.9v23.42a5.01 5.01 0 0 0-3.9 3.9h-6.68a4.952 4.952 0 0 0-1.59-2.72l.2-.19c.61-.6.94-1.4.95-2.26 0-.85-.33-1.66-.93-2.27zM19.23 10.96c-.69 0-1.25-.56-1.25-1.25 0-.33.13-.65.37-.88s.55-.37.88-.37h2.26v2.5zm2.88 32.37c.37.16.8.07 1.09-.21l4.71-4.66c.23-.23.49-.34.85-.35.32 0 .62.13.84.35.46.47.46 1.23-.01 1.69l-2.63 2.6c-.75.75-1.33 1.68-1.67 2.68l-1.46 4.36c-.02.06-.04.11-.07.16l-.05.13c-.09.23-.19.81-.28.9l-6.51 6.44-7.12-7.17 5.68-11.91c.02-.03.04-.07.07-.1l5.95-5.89V42.4c-.01.41.24.77.61.93z"
                                                opacity="1" data-original="#000000" class="">
                                            </path>
                                        </g>
                                    </svg>
                                </div>
                                <div class="widget-three__content">
                                    <h3> {{ showAmount($user->withdrawals->where('status', 1)->sum('amount')) }}
                                    </h3>
                                    <p>@lang('Total Withdraw')</p>
                                    <a href="{{ route('user.withdraw.history') }}" class="btn cmn-btn mt-2">@lang('Withdraw
                                                                                                            History ')<i
                                            class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <a href="{{ route('user.ptc.clicks') }}" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--primary"><svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 512.021 512.021"
                                style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="m481.515 229.003-80.235-88.128c-15.381-15.424-42.091-15.531-57.749.128-5.056 5.056-8.512 11.136-10.304 17.621-15.573-11.947-39.339-10.645-53.696 3.712a40.453 40.453 0 0 0-10.347 17.6c-15.531-11.947-39.317-10.581-53.653 3.733a40.507 40.507 0 0 0-10.24 17.216l-37.803-37.803c-15.893-15.872-41.707-15.915-57.771.128-15.893 15.872-15.893 41.728 0 57.621l145.237 145.237-86.101 13.525C145.557 382.923 128 403.147 128 426.677c0 17.643 14.357 32 32 32h201.152c31.317 0 60.779-12.203 83.008-34.389l33.536-33.557c22.144-22.123 34.325-51.563 34.325-82.859 0-29.227-10.837-57.237-30.506-78.869zm-18.923 146.666-33.536 33.557c-18.155 18.133-42.283 28.117-67.904 28.117H160c-5.867 0-10.667-4.779-10.667-10.667 0-12.971 9.685-24.128 22.656-26.005l106.987-16.811c3.968-.619 7.232-3.413 8.491-7.232 1.237-3.797.235-8-2.603-10.837L124.8 205.728c-7.552-7.573-7.552-19.883.128-27.584a19.436 19.436 0 0 1 13.739-5.675c4.971 0 9.941 1.899 13.739 5.696L215.04 240.8c.149.171.341.341.512.512l43.605 43.584c4.16 4.16 10.923 4.16 15.083 0s4.16-10.923 0-15.083l-43.968-43.968c-7.189-7.595-7.061-19.648.491-27.221 7.339-7.296 20.096-7.339 27.435 0l20.971 20.992c.128.128.235.256.363.363l22.272 22.251c4.16 4.16 10.923 4.16 15.083 0s4.16-10.923 0-15.083l-22.528-22.507c-7.275-7.595-7.189-19.733.405-27.349 7.317-7.296 20.096-7.339 27.435 0l22.272 22.357c.021.021.021.043.043.043l.021.021.085.043s0 .021.021.021l.021.021.021.021h.042c4.224 3.925 10.795 3.819 14.848-.277 4.139-4.16 4.139-10.901-.021-15.061l-1.28-1.28c-7.211-7.595-7.104-19.669.469-27.243 7.339-7.296 20.437-6.976 27.093-.363l79.872 87.787c16.107 17.707 24.96 40.597 24.96 64.512.001 25.579-9.983 49.664-28.074 67.776z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M344.597 199.755h.021l-.043-.021c.022.021.044.021.022.021zM226.069 152.629c-15.552-34.389-49.835-56.619-87.403-56.619-52.928 0-96 43.072-96 96 0 37.547 22.229 71.851 56.597 87.403a10.694 10.694 0 0 0 14.123-5.333c2.411-5.376.043-11.691-5.333-14.123C81.301 247.861 64 221.195 64 192.011c0-41.173 33.493-74.667 74.667-74.667 29.184 0 55.851 17.301 67.947 44.053a10.661 10.661 0 0 0 14.123 5.333c5.354-2.41 7.743-8.746 5.332-14.101z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M272.533 156.363C256.427 95.712 201.365 53.344 138.667 53.344 62.208 53.344 0 115.552 0 192.011c0 62.699 42.368 117.76 103.04 133.867.917.256 1.835.363 2.731.363 4.736 0 9.045-3.136 10.304-7.915 1.515-5.696-1.856-11.541-7.573-13.056-51.307-13.632-87.168-60.203-87.168-113.259 0-64.704 52.651-117.333 117.333-117.333 53.035 0 99.627 35.84 113.259 87.168 1.493 5.675 7.147 9.088 13.056 7.573 5.674-1.515 9.045-7.36 7.551-13.056z"
                                        opacity="1" data-original="#000000"></path>
                                </g>
                            </svg></div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang('Total Clicks')</p>
                            <h3 class="fw-bold">{{ $user->clicks->count() }}</h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>
                <a href="{{ route('user.ptc.index') }}" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center  b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--danger">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="M511.213 455.33c-1.952-13.798-51.19-331.44-56.503-370.66-2.656-19.771-19.638-34.894-39.939-34.894h-48.494V26.672c0-10.768-8.761-19.529-19.529-19.529h-4.006c-10.769 0-19.529 8.761-19.529 19.529v23.103h-81.122V26.672c0-10.768-8.761-19.529-19.529-19.529h-4.006c-10.769 0-19.529 8.761-19.529 19.529v23.103h-81.122V26.672c0-10.768-8.761-19.529-19.529-19.529H94.37c-10.769 0-19.529 8.761-19.529 19.529v23.103H40.312C18.084 49.775 0 67.859 0 90.086v374.458c0 22.228 18.084 40.312 40.312 40.312h431.915c16.799 0 31.998-10.584 37.8-26.283.79-2.09 3.207-9.93 1.186-23.243zM338.236 26.672a4.512 4.512 0 0 1 4.507-4.507h4.006a4.512 4.512 0 0 1 4.507 4.507v66.767a4.512 4.512 0 0 1-4.507 4.507h-4.006a4.512 4.512 0 0 1-4.507-4.507V26.672zm-10.495 79.256c.346.415.713.81 1.091 1.194.062.063.123.127.186.189.385.382.787.745 1.203 1.093l.229.189c.422.344.857.671 1.308.978.069.047.14.092.21.138.473.313.956.613 1.456.885.026.014.053.026.079.041.498.268 1.009.514 1.532.739l.166.074a19.77 19.77 0 0 0 1.587.582c.09.029.179.059.27.086a19.841 19.841 0 0 0 3.613.737c.076.008.152.012.228.02.608.057 1.221.093 1.843.093h4.006c.622 0 1.235-.036 1.843-.093.076-.007.153-.011.228-.02a19.395 19.395 0 0 0 1.992-.319c.55-.117 1.091-.255 1.621-.418l.27-.086c.539-.173 1.07-.365 1.587-.582l.166-.074a19.287 19.287 0 0 0 1.532-.739c.026-.014.053-.026.079-.041.501-.272.983-.572 1.456-.885.07-.046.141-.091.21-.138.451-.307.885-.635 1.308-.978l.229-.189c.416-.349.817-.711 1.203-1.093.063-.062.124-.126.186-.189.376-.384.743-.779 1.089-1.194.013.271.02.542.02.814 0 9.388-7.637 17.025-17.026 17.025-9.388 0-17.025-7.637-17.025-17.025.005-.272.011-.543.025-.814zm-113.69-79.256a4.512 4.512 0 0 1 4.507-4.507h4.006a4.512 4.512 0 0 1 4.507 4.507v66.767a4.512 4.512 0 0 1-4.507 4.507h-4.006a4.512 4.512 0 0 1-4.507-4.507V26.672zm-10.497 79.256c.346.415.713.81 1.091 1.194.062.063.123.127.186.189.385.382.787.745 1.203 1.093l.229.189c.422.344.857.671 1.308.978.069.047.14.092.21.138.473.313.956.613 1.456.885.026.014.053.026.079.041.498.268 1.01.514 1.532.739l.166.074a19.77 19.77 0 0 0 1.587.582c.09.029.179.059.27.086a19.841 19.841 0 0 0 3.613.737c.076.008.152.012.229.02.607.057 1.221.093 1.843.093h4.006c.622 0 1.235-.036 1.843-.093.076-.007.153-.011.229-.02a19.395 19.395 0 0 0 1.992-.319c.55-.117 1.091-.255 1.621-.418l.27-.086c.539-.173 1.07-.365 1.587-.582l.166-.074a19.287 19.287 0 0 0 1.532-.739c.026-.014.053-.026.079-.041.5-.272.983-.572 1.456-.885.07-.046.141-.091.21-.138.451-.307.885-.635 1.308-.978l.229-.189c.416-.349.817-.711 1.203-1.093.063-.062.124-.126.186-.189.375-.384.742-.779 1.088-1.194.013.271.02.542.02.814 0 9.388-7.637 17.025-17.026 17.025s-17.026-7.637-17.026-17.025c.006-.272.012-.543.025-.814zM89.864 26.672a4.512 4.512 0 0 1 4.507-4.507h4.006a4.512 4.512 0 0 1 4.507 4.507v66.767a4.512 4.512 0 0 1-4.507 4.507H94.37a4.512 4.512 0 0 1-4.507-4.507l.001-66.767zm-4.813 83.924c.026.014.053.026.079.041.498.268 1.01.514 1.532.739l.166.074a19.77 19.77 0 0 0 1.587.582c.09.029.179.059.269.086a19.841 19.841 0 0 0 3.613.737c.076.008.152.012.229.02.607.057 1.221.093 1.843.093h4.006c.622 0 1.235-.036 1.843-.093.076-.007.153-.011.229-.02a19.395 19.395 0 0 0 1.992-.319c.55-.117 1.091-.255 1.621-.418l.27-.086c.539-.173 1.07-.365 1.587-.582l.166-.074a19.287 19.287 0 0 0 1.532-.739c.026-.014.053-.026.079-.041.5-.272.984-.572 1.456-.885.07-.046.141-.091.21-.138.451-.307.885-.635 1.308-.978l.229-.189c.416-.349.817-.711 1.203-1.093.063-.062.124-.126.186-.189.376-.385.743-.78 1.089-1.195.013.271.02.542.02.814 0 9.388-7.637 17.025-17.026 17.025-9.726 0-17.478-8.17-17.005-17.84a20.107 20.107 0 0 0 5.687 4.668zm-70.028-20.51c0-13.944 11.345-25.289 25.29-25.289h34.53v18.224c-21.624 19.649-7.676 55.769 21.532 55.769 17.671 0 32.048-14.377 32.048-32.048 0-9.084-3.872-17.685-10.516-23.722V64.798h81.122v18.224c-6.644 6.037-10.516 14.637-10.516 23.721 0 17.672 14.377 32.048 32.048 32.048s32.048-14.377 32.048-32.048c0-9.084-3.872-17.685-10.516-23.722V64.798h81.122v18.224c-6.644 6.037-10.516 14.637-10.516 23.721 0 17.672 14.377 32.048 32.048 32.048 17.672 0 32.048-14.377 32.048-32.048 0-9.084-3.872-17.685-10.516-23.722V64.798h48.494c13.945 0 25.291 11.345 25.291 25.289v76.746H15.023V90.086zm480.933 383.226c-3.653 9.883-13.189 16.523-23.73 16.523h-26.094c5.592-6.921 8.951-15.719 8.951-25.29v-99.483a7.511 7.511 0 0 0-15.022 0v99.483c0 13.945-11.346 25.29-25.291 25.29H40.312c-13.945 0-25.29-11.345-25.29-25.29V209.898h188.062a7.511 7.511 0 0 0 0-15.022H15.023v-13.02h425.04v13.02H238.036a7.511 7.511 0 0 0 0 15.022h202.027V330.01a7.511 7.511 0 0 0 15.022 0V188.568L496.33 457.38l.017.113c1.588 10.359-.351 15.713-.391 15.819z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M171.187 248.408h-24.729a7.511 7.511 0 0 0 0 15.022h24.729a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM239.936 248.408h-24.732a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM308.686 248.408h-24.733a7.511 7.511 0 0 0 0 15.022h24.733a7.511 7.511 0 0 0 0-15.022zM377.432 248.408H352.7a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM102.44 308.924H77.708a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.509 7.509 0 0 0-7.511-7.511zM171.187 308.924h-24.729a7.511 7.511 0 0 0 0 15.022h24.729a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM239.936 308.924h-24.732a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.509 7.509 0 0 0-7.511-7.511zM308.686 308.924h-24.733a7.511 7.511 0 0 0 0 15.022h24.733a7.511 7.511 0 0 0 0-15.022zM377.432 308.924H352.7a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.509 7.509 0 0 0-7.511-7.511zM102.44 369.441H77.708a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM171.187 369.441h-24.729a7.511 7.511 0 0 0 0 15.022h24.729a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM239.936 369.441h-24.732a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM308.686 369.441h-24.733a7.511 7.511 0 0 0 0 15.022h24.733a7.511 7.511 0 0 0 0-15.022zM377.432 369.441H352.7a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM102.44 429.959H77.708a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM171.187 429.959h-24.729a7.511 7.511 0 0 0 0 15.022h24.729a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM239.936 429.959h-24.732a7.511 7.511 0 0 0 0 15.022h24.732a7.51 7.51 0 0 0 7.511-7.511 7.51 7.51 0 0 0-7.511-7.511zM308.686 429.959h-24.733a7.511 7.511 0 0 0 0 15.022h24.733a7.511 7.511 0 0 0 0-15.022z"
                                        opacity="1" data-original="#000000"></path>
                                </g>
                            </svg>
                        </div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang('Remain clicks for today')</p>
                            <h3 class="fw-bold">
                                {{ $user->daily_limit - $user->clicks->where('view_date', Date('Y-m-d'))->count() }}
                            </h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>
                <a href="{{ route('user.ptc.clicks') }}" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center  b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--success"><svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 512.021 512.021"
                                style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="m481.515 229.003-80.235-88.128c-15.381-15.424-42.091-15.531-57.749.128-5.056 5.056-8.512 11.136-10.304 17.621-15.573-11.947-39.339-10.645-53.696 3.712a40.453 40.453 0 0 0-10.347 17.6c-15.531-11.947-39.317-10.581-53.653 3.733a40.507 40.507 0 0 0-10.24 17.216l-37.803-37.803c-15.893-15.872-41.707-15.915-57.771.128-15.893 15.872-15.893 41.728 0 57.621l145.237 145.237-86.101 13.525C145.557 382.923 128 403.147 128 426.677c0 17.643 14.357 32 32 32h201.152c31.317 0 60.779-12.203 83.008-34.389l33.536-33.557c22.144-22.123 34.325-51.563 34.325-82.859 0-29.227-10.837-57.237-30.506-78.869zm-18.923 146.666-33.536 33.557c-18.155 18.133-42.283 28.117-67.904 28.117H160c-5.867 0-10.667-4.779-10.667-10.667 0-12.971 9.685-24.128 22.656-26.005l106.987-16.811c3.968-.619 7.232-3.413 8.491-7.232 1.237-3.797.235-8-2.603-10.837L124.8 205.728c-7.552-7.573-7.552-19.883.128-27.584a19.436 19.436 0 0 1 13.739-5.675c4.971 0 9.941 1.899 13.739 5.696L215.04 240.8c.149.171.341.341.512.512l43.605 43.584c4.16 4.16 10.923 4.16 15.083 0s4.16-10.923 0-15.083l-43.968-43.968c-7.189-7.595-7.061-19.648.491-27.221 7.339-7.296 20.096-7.339 27.435 0l20.971 20.992c.128.128.235.256.363.363l22.272 22.251c4.16 4.16 10.923 4.16 15.083 0s4.16-10.923 0-15.083l-22.528-22.507c-7.275-7.595-7.189-19.733.405-27.349 7.317-7.296 20.096-7.339 27.435 0l22.272 22.357c.021.021.021.043.043.043l.021.021.085.043s0 .021.021.021l.021.021.021.021h.042c4.224 3.925 10.795 3.819 14.848-.277 4.139-4.16 4.139-10.901-.021-15.061l-1.28-1.28c-7.211-7.595-7.104-19.669.469-27.243 7.339-7.296 20.437-6.976 27.093-.363l79.872 87.787c16.107 17.707 24.96 40.597 24.96 64.512.001 25.579-9.983 49.664-28.074 67.776z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M344.597 199.755h.021l-.043-.021c.022.021.044.021.022.021zM226.069 152.629c-15.552-34.389-49.835-56.619-87.403-56.619-52.928 0-96 43.072-96 96 0 37.547 22.229 71.851 56.597 87.403a10.694 10.694 0 0 0 14.123-5.333c2.411-5.376.043-11.691-5.333-14.123C81.301 247.861 64 221.195 64 192.011c0-41.173 33.493-74.667 74.667-74.667 29.184 0 55.851 17.301 67.947 44.053a10.661 10.661 0 0 0 14.123 5.333c5.354-2.41 7.743-8.746 5.332-14.101z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M272.533 156.363C256.427 95.712 201.365 53.344 138.667 53.344 62.208 53.344 0 115.552 0 192.011c0 62.699 42.368 117.76 103.04 133.867.917.256 1.835.363 2.731.363 4.736 0 9.045-3.136 10.304-7.915 1.515-5.696-1.856-11.541-7.573-13.056-51.307-13.632-87.168-60.203-87.168-113.259 0-64.704 52.651-117.333 117.333-117.333 53.035 0 99.627 35.84 113.259 87.168 1.493 5.675 7.147 9.088 13.056 7.573 5.674-1.515 9.045-7.36 7.551-13.056z"
                                        opacity="1" data-original="#000000"></path>
                                </g>
                            </svg></div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang("Today's Clicks")</p>
                            <h3 class="fw-bold">
                                {{ $user->clicks->where('view_date', Date('Y-m-d'))->count() }}
                            </h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>
                <a href="javascript:void(0)" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center  b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--warning">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                viewBox="0 0 480 480.233" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="M208.117 96c-97.203 0-176 78.797-176 176s78.797 176 176 176 176-78.797 176-176c-.11-97.156-78.844-175.89-176-176zm0 336c-88.367 0-160-71.633-160-160s71.633-160 160-160c88.363 0 160 71.633 160 160-.101 88.324-71.676 159.898-160 160zm0 0"
                                        opacity="1" data-original="#000000" class=""></path>
                                    <path
                                        d="m371.086 142.984 12.367-12.367a8.004 8.004 0 0 0 0-11.312l-22.64-22.64a7.997 7.997 0 0 0-11.313 0l-12.367 12.366a206.924 206.924 0 0 0-105.016-43.605V48h8c8.836 0 16-7.164 16-16V16c0-8.836-7.164-16-16-16h-64c-8.836 0-16 7.164-16 16v16c0 8.836 7.164 16 16 16h8v17.426A206.924 206.924 0 0 0 79.102 109.03L66.734 96.664c-3.125-3.125-8.191-3.125-11.312 0l-22.64 22.64a7.997 7.997 0 0 0 0 11.313l12.366 12.367c-67.546 85.168-58.12 207.985 21.63 281.852 79.75 73.863 202.929 73.863 282.679 0 79.75-73.867 89.176-196.684 21.629-281.852zm-15.93-29.382 11.36 11.359-5.832 5.832a205.196 205.196 0 0 0-11.329-11.328zM176.117 16h64v16h-64zm24 32h16v16.2c-2.656-.095-5.32-.2-8-.2-2.68 0-5.344.105-8 .2zM49.715 124.96l11.363-11.358 5.832 5.832a199.905 199.905 0 0 0-11.328 11.328zM208.117 464c-106.039 0-192-85.96-192-192s85.961-192 192-192c106.04 0 192 85.96 192 192-.125 105.988-86.012 191.875-192 192zm0 0"
                                        opacity="1" data-original="#000000" class=""></path>
                                    <path
                                        d="M232.117 272c0-13.254-10.746-24-24-24s-24 10.746-24 24 10.746 24 24 24a23.692 23.692 0 0 0 10.281-2.398l48.063 48.062 11.312-11.312-48.058-48.07A23.641 23.641 0 0 0 232.117 272zm-32 0a8 8 0 1 1 16.001 0 8 8 0 0 1-16 0zM242.246 148.602 237.988 164a112.09 112.09 0 0 1 71.23 59.805 112.098 112.098 0 0 1 1.571 92.996l14.664 6.398A127.038 127.038 0 0 0 336.117 272c-.094-57.523-38.46-107.957-93.87-123.398zM225.172 145.129A129.016 129.016 0 0 0 208.117 144v16c4.996 0 9.988.328 14.946.984zm0 0"
                                        opacity="1" data-original="#000000" class=""></path>
                                </g>
                            </svg>
                        </div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang('Next Reminder')</p>
                            <h3 class="fw-bold timer" id="counter"></h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>

                <a href="{{ route('user.commissions') }}" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center  b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--info">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                viewBox="0 0 64 64" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="M49 34c-3.976 0-8 1.374-8 4v5.268C39.459 42.43 37.222 42 35 42c-3.976 0-8 1.374-8 4v10c0 5.31 16 5.33 16 0v-.285c4.365 2.401 14 1.376 14-2.715V38c0-2.626-4.024-4-8-4zm6 14c0 .705-2.278 2-6 2-2.763 0-4.131-.689-4.66-.843C43.414 48.74 43 48.275 43 48v-2.286c3.204 1.763 8.977 1.661 12 .018zm-26 .732c3.108 1.688 8.891 1.689 12 0V51c0 .705-2.278 2-6 2s-6-1.295-6-2zM55 43c0 1.409-6.385 3.004-10.572 1.195C43.441 43.77 43 43.288 43 43v-2.268c3.108 1.688 8.891 1.689 12 0zm-6-7c3.722 0 6 1.295 6 2s-2.278 2-6 2-6-1.295-6-2 2.278-2 6-2zm-14 8c3.722 0 6 1.295 6 2s-2.278 2-6 2-6-1.295-6-2 2.278-2 6-2zm0 14c-3.722 0-6-1.295-6-2v-2.268c3.108 1.688 8.891 1.689 12 0V56c0 .705-2.278 2-6 2zm9.443-3.798C43.452 53.777 43 53.281 43 53v-2.289c3.19 1.761 8.966 1.67 12 .021V53c0 1.398-6.337 3.009-10.557 1.202zM50 21c2.206 0 4-1.794 4-4s-1.794-4-4-4-4 1.794-4 4 1.794 4 4 4zm0-6c1.102 0 2 .897 2 2s-.898 2-2 2c-1.103 0-2-.897-2-2s.897-2 2-2zM57 24c-2.206 0-4 1.794-4 4s1.794 4 4 4 4-1.794 4-4-1.794-4-4-4zm0 6c-1.103 0-2-.897-2-2s.897-2 2-2c1.102 0 2 .897 2 2s-.898 2-2 2zM47.707 29.707l12-12c.936-.936-.479-2.35-1.414-1.414l-12 12c-.948.948.492 2.336 1.414 1.414z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M24.001 52H16c-2.757 0-5-2.243-5-5V11a6.977 6.977 0 0 0-2.106-5H37c2.757 0 5 2.243 5 5v20.441c0 1.322 2 1.324 2 0V11c0-3.86-3.141-7-7-7H4C2.676 4 2.678 6 4 6c2.757 0 5 2.243 5 5v36c0 3.86 3.141 7 7 7h8.001c1.324 0 1.322-2 0-2z"
                                        opacity="1" data-original="#000000"></path>
                                    <path
                                        d="M16 11h16c1.324 0 1.322-2 0-2H16c-1.324 0-1.322 2 0 2zM37 21h-7c-1.324 0-1.322 2 0 2h7c1.324 0 1.322-2 0-2zM16 23h10c1.324 0 1.322-2 0-2H16c-1.324 0-1.322 2 0 2zM23 36h-7c-1.324 0-1.322 2 0 2h7c1.324 0 1.322-2 0-2zM32 38c1.324 0 1.322-2 0-2h-5c-1.324 0-1.322 2 0 2zM16 28h4c1.324 0 1.322-2 0-2h-4c-1.324 0-1.322 2 0 2zM16 41c-1.324 0-1.322 2 0 2h6c1.324 0 1.322-2 0-2zM16 33h1c1.324 0 1.322-2 0-2h-1c-1.324 0-1.322 2 0 2zM27.001 31h-6c-1.322 0-1.324 2 0 2h6c1.324 0 1.322-2 0-2zM31 26h-7c-1.324 0-1.322 2 0 2h7c1.324 0 1.322-2 0-2zM37 26h-2c-1.324 0-1.322 2 0 2h2c1.324 0 1.322-2 0-2zM37 36h-1c-1.324 0-1.322 2 0 2h1c1.324 0 1.322-2 0-2zM16 15h6.001c1.324 0 1.322-2 0-2H16c-1.324 0-1.322 2 0 2zM37 31h-6c-1.324 0-1.322 2 0 2h6c1.324 0 1.322-2 0-2z"
                                        opacity="1" data-original="#000000"></path>
                                </g>
                            </svg>
                        </div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang('Referral Commissions')</p>
                            <h3 class="fw-bold">
                                {{ __($commissionCount) }} {{ gs('cur_text') }}
                            </h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>

                <a href="{{ route('user.ptc.ads') }}" class="col-lg-6 col-md-12 mb-30">
                    <div class="widget d-flex align-items-center  b-radius--8 bg--white p-3 border--widget">
                        <div class="widget__icon b-radius--8 w-bg--primary">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0"
                                viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                <g>
                                    <path
                                        d="M488.639 40.094H23.361A7.369 7.369 0 0 0 16 47.455v341.553a7.369 7.369 0 0 0 7.361 7.361H209.7v26.746h-61.746a24.4 24.4 0 0 0 0 48.791h216.093a24.4 24.4 0 0 0 0-48.791H302.3v-26.746h186.339a7.369 7.369 0 0 0 7.361-7.361V47.455a7.369 7.369 0 0 0-7.361-7.361zm-5.415 12.776v279.669H28.776V52.87zM375.666 447.511a11.632 11.632 0 0 1-11.619 11.619H147.954a11.62 11.62 0 0 1 0-23.239h216.093a11.633 11.633 0 0 1 11.619 11.62zm-86.145-24.4h-67.042v-26.742h67.042zM28.776 383.594v-38.28h454.448v38.28zM65.855 365.7a6.387 6.387 0 0 1-6.387 6.388h-1.551a6.388 6.388 0 1 1 0-12.776h1.551a6.387 6.387 0 0 1 6.387 6.388zM70.9 246.085a24.965 24.965 0 0 0 13.47 14.674 26.87 26.87 0 0 0 11.165 2.423 27.847 27.847 0 0 0 9.045-1.525 605.37 605.37 0 0 0 4.172-1.489l15.219 25.222c4.083 6.767 8.731 8.522 12.608 8.522a18.163 18.163 0 0 0 6.94-1.624c.378-.155.744-.309 1.1-.43l8.549-2.934a11.835 11.835 0 0 0 7.418-7.151 12.114 12.114 0 0 0-1.256-10.468l-12.818-20.775c4.458.012 9.919.295 17.246.779l61.1 3.693a18.845 18.845 0 0 0 35.4-12.922l-10.894-31.74c5.833-2.677 10.113-8.517 11.859-16.313 1.683-7.513.994-16.358-1.94-24.906s-7.822-15.953-13.764-20.849c-6.165-5.08-13.129-7.062-19.377-5.592l-10.435-30.4a18.874 18.874 0 0 0-23.951-11.712 18.848 18.848 0 0 0-12 22.956l-45.781 40.906c-9.971 8.674-15.622 13.2-21.13 16.332a6.3 6.3 0 0 0-.837.467c-5.113 2.784-10.286 4.483-18.866 7.3-3.528 1.159-7.527 2.472-12.3 4.111a27.165 27.165 0 0 0-15.349 13.1 24.968 24.968 0 0 0-1.62 19.853zm69.572 33.689c-.575.2-1.172.437-1.785.687a13.587 13.587 0 0 1-1.9.679 7.882 7.882 0 0 1-1.875-2.35l-13.942-23.105a108.74 108.74 0 0 1 11.43-3.693l15.56 25.212zM237.4 158.132c4.085 3.366 7.658 8.882 9.8 15.136s2.714 12.8 1.558 17.967c-.7 3.137-1.984 5.507-3.615 6.8l-14.778-43.059c2.084.029 4.551 1.112 7.035 3.156zm-44.965-42.4a6.062 6.062 0 0 1 11.193.691l12.54 36.536.008.026.008.021 18.987 55.319c.006.02.01.04.017.06s.012.025.016.038l12.975 37.8a6.077 6.077 0 1 1-11.5 3.946l-1.161-3.38-.021-.063-42.306-123.264-.024-.068-1.038-3.025a6.032 6.032 0 0 1 .302-4.635zm-50.007 58.279 41.793-37.343 36.126 105.26-55.778-3.372c-11.217-.742-18.6-1-24.674-.595l-16.67-48.573c5.075-3.38 10.775-8.044 19.199-15.375zm-65.617 37.656a14.439 14.439 0 0 1 8.176-6.942c4.7-1.612 8.651-2.911 12.141-4.057 6.05-1.987 10.638-3.526 14.672-5.2l15.343 44.7c-4.108 1.156-8.545 2.763-14.35 4.911l-3.4 1.255-.03.011a688.325 688.325 0 0 1-8.976 3.241 14.429 14.429 0 0 1-10.716-.458 12.312 12.312 0 0 1-6.681-7.2l-7.033-20.489a12.312 12.312 0 0 1 .854-9.772zm283.554-96.3a6.388 6.388 0 0 1 6.388-6.388h76.321a6.388 6.388 0 0 1 0 12.776h-76.321a6.388 6.388 0 0 1-6.388-6.393zM299.4 154.551a6.388 6.388 0 0 1 6.388-6.388h137.286a6.388 6.388 0 0 1 0 12.776H305.785a6.388 6.388 0 0 1-6.385-6.388zm150.061 39.189a6.387 6.387 0 0 1-6.387 6.388H420.3a6.388 6.388 0 1 1 0-12.776h22.773a6.387 6.387 0 0 1 6.388 6.388zm-150.064 0a6.388 6.388 0 0 1 6.388-6.388h91.076a6.388 6.388 0 1 1 0 12.776h-91.076a6.388 6.388 0 0 1-6.385-6.388zm0 39.189a6.387 6.387 0 0 1 6.388-6.388h137.289a6.388 6.388 0 0 1 0 12.775H305.785a6.387 6.387 0 0 1-6.385-6.387zm0 39.188a6.388 6.388 0 0 1 6.388-6.388h17.179a6.388 6.388 0 0 1 0 12.776h-17.179a6.388 6.388 0 0 1-6.385-6.388zm150.064 0a6.387 6.387 0 0 1-6.387 6.388H346.4a6.388 6.388 0 0 1 0-12.776h96.671a6.387 6.387 0 0 1 6.39 6.388z"
                                        opacity="1" data-original="#000000" class=""></path>
                                </g>
                            </svg>
                        </div>
                        <div class="widget__content">
                            <p class="text-muted mb-0">@lang('My Active ADS')</p>
                            <h3 class="fw-bold">
                                {{ __($activeAdCount) }}
                            </h3>
                        </div>
                        <div class="widget__arrow">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </a>

            </div>
        </div>
    </section>

    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif


@endsection
@push('script')
    <script src="{{ asset('assets/admin/js/vendor/apexcharts.min.js') }}"></script>
    <script>
        (function($) {
            "use strict";
            // apex-bar-chart js
            var options = {
                series: [{
                    name: 'Clicks',
                    data: [
                        @foreach ($chart['click'] as $key => $click)
                            {{ $click }},
                        @endforeach
                    ]
                }, {
                    name: 'Earn Amount',
                    data: [
                        @foreach ($chart['amount'] as $key => $amount)
                            {{ $amount }},
                        @endforeach
                    ]
                }],
                chart: {
                    type: 'bar',
                    height: 455,
                    toolbar: {
                        show: false
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '55%',
                        endingShape: 'rounded'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: [
                        @foreach ($chart['amount'] as $key => $amount)
                            '{{ $key }}',
                        @endforeach
                    ],
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return val
                        }
                    }
                }
            };
            var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
            chart.render();

            function createCountDown(elementId, sec) {
                var tms = sec;
                var x = setInterval(function() {
                    var distance = tms * 1000;
                    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                    document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes +
                        "m " + seconds + "s ";
                    if (distance < 0) {
                        clearInterval(x);
                        document.getElementById(elementId).innerHTML = "{{ __('COMPLETE') }}";
                    }
                    tms--;
                }, 1000);
            }
            createCountDown('counter', {{ \Carbon\Carbon::tomorrow()->diffInSeconds() }});
        })(jQuery);
    </script>
@endpush
